       //================\\
      //  Kevin Peterson  \\
     //  Brandon S. Parker \\
    //Cheryl-Annette Kincaid\\
   //      CSCI 3780.001     \\
  //      April 29, 2003      \\
 //        labrynthd.cc        \\
//==============================\\
//********************************************************************
//*                      Project #2:                                 *
//*                                                                  *
//* Source files:  labrynth.cc, labrynthd.cc, Queue.cpp              *
//*                                                                  *
//* Input: console and socket                                        *
//*                                                                  *
//* Output: console and socket                                       *
//*                                                                  *
//* Compile with: make 	                                             *
//*                                                                  *
//* Objective: provides an interactive network game that supports    *
//*            up to eight players                                   *
//*                                                                  *
//* Authors:                                                         *
//*  Brandon S. Parker, Kevin Peterson, Cheryl-Annet Kincaid         *
//*  (c) 2003                                                        *
//*                                                                  *
//********************************************************************

#include <iostream.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <fstream.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/un.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "gameserver.h"


int PlayerByPort(unsigned int portnum, unsigned int players[]);
int FindOpenSlot(unsigned int players[]);
int DEBUG = 1;

struct sendpacket
{
int playernum;
char chat[80];
unsigned int players[9][2];
unsigned int map[81][81];
};

struct recvpacket
{
char command;
int playernum;
char chat[80];
};

void main(int argc, char *argv[])
{

system("host ${HOSTNAME}");
//*** Randomize for the map
	srand((unsigned int)getCPUTime());
	
//*** create map and player information:

	unsigned int PlayerPorts[8];
	sendpacket INFO;
	recvpacket RECV;

	if (DEBUG == 2) cout<<"Sizeof(package) = "<<sizeof(INFO)<<endl;
	
	InitServer(INFO.map,INFO.players);
	strcpy(INFO.chat,"This is just a blank statement");	

	 for (int a=0; a<=7; a++)
                PlayerPorts[a] = 0;

        if (DEBUG == 2) cout<<"size of array: "<<sizeof(INFO)<<endl;
	
//*** Set up the server socket info:

        int server_sockfd, client_sockfd;
        unsigned int server_len, client_len;
        struct sockaddr_in server_address;
        struct sockaddr_in client_address;
	int result;
	fd_set readfds, testfds;

// *** Create an unnamed socket for the server:

	printf("Setting socket...\n");
        server_sockfd = socket(AF_INET, SOCK_STREAM, 0);
	if (server_sockfd < 1)
		{
		perror("ERR: socket could not be established.\n");
		exit(1);
		}
	
// *** Name the socket:

        server_address.sin_family = AF_INET;
        server_address.sin_addr.s_addr = htonl(INADDR_ANY); 
        server_address.sin_port = 9788; // Take your pick
        server_len = sizeof(server_address);
	printf("Binding...\n");

        if (bind(server_sockfd, (struct sockaddr *)&server_address, server_len) < 0)
	{
		perror("ERR: Bind failed");
		exit(1);
	}
// *** Create a connection queue and wait for clients:

	printf("Listening...\n");
	listen(server_sockfd, 15);
	FD_ZERO(&readfds);
	FD_SET(server_sockfd, &readfds);
	int OpenSlot = 0;
        char ch, response;
        int fd;
        int nread;

	while (1)
		{
		testfds = readfds;
		cout<<'.';
		if (DEBUG == 2) printf("server waiting\n");
	
		// *** If the SUper Monster has been slain, reset the server
		if(INFO.players[8][1]%512==0)
                        InitServer(INFO.map,INFO.players);
			

	
	// *** Accept a connection:
	
		result = select(FD_SETSIZE, &testfds, (fd_set *)0, (fd_set *)0, (struct timeval *) 0);

		if (result < 1)
			{
			perror("ERR: selecting Server5");
			exit(1);
			}
		for(fd = 0; fd < FD_SETSIZE; fd++)
			if(FD_ISSET(fd,&testfds))
			{ 
			//*** if connection on well known port, spawn new socket

			    if (fd == server_sockfd)
			    { //If fd >= 8 then no connect;

				if (DEBUG == 2) cout<<"---> TRYING TO FIND OPEN SLOT"<<endl;
				OpenSlot = FindOpenSlot(PlayerPorts);
				if (DEBUG == 2) cout<<"OpenSlot = "<<OpenSlot<<endl;
				if (OpenSlot != -1)
				{
					client_len = sizeof(client_address);
					client_sockfd = accept(server_sockfd, (struct sockaddr *)&client_address, &client_len);
					FD_SET(client_sockfd, &readfds);
					printf("Adding client on fd %d and port:%d\n", client_sockfd, client_address.sin_port);
					PlayerPorts[OpenSlot] = client_sockfd;	
					 CodePlayerLocation(INFO.players[OpenSlot][0],int(rand()%81),int(rand()%81));
                                        				
			    	}
				else 
				{
                                        close(fd);
                                        printf("A player was rejected on fd %d\n",fd);
                                }

			    }
			    else
			    {
			//*** so we are now getting data from a pre-existing client
				ioctl(fd, FIONREAD, &nread);
				if (nread ==0)
				{
					INFO.players[PlayerByPort(fd, PlayerPorts)][1] = 100;
					CodePlayerLocation(INFO.players[PlayerByPort(fd, PlayerPorts)][0], 0, 0); 
					close(fd);
					FD_CLR(fd, &readfds);
					PlayerPorts[PlayerByPort(fd, PlayerPorts)] = 0;
					printf("Removing client on fd %d\n",fd);
				}
				else
				{
					read(fd, &RECV, sizeof(RECV));
					INFO.playernum = RECV.playernum; // Give the player their number
					INFO.chat = RECV.chat;

					if (DEBUG == 2) cout<<"We Got: "<<RECV.command<<" from player "<<INFO.playernum<<endl;
					
					switch(RECV.command)
					{
					case 'a':
					case 'd':
					case 's':
					case 'w':
						Move(INFO.map, INFO.players, RECV.playernum, RECV.command);
						break;

					//case 't':
						//Do something here with RECV.chat[80];						
						// And dishing it out via INFO.chat[80];
					//	INFO.chat = RECV.chat;
					//	break;
					default:
					//	INFO.playernum = PlayerByPort(fd, PlayerPorts); // Give the player their number
					//	write(fd, &INFO, sizeof(INFO));
						if (DEBUG == 2) cout<<"PlayerNum: "<<INFO.playernum<<endl;		
						if (DEBUG == 2) cout<<"Chat: "<<INFO.chat<<endl;
					} //end switch
					
					for (int i = 4; i < 12; i++)
					      {
						INFO.playernum = PlayerByPort(i, PlayerPorts);
						write(i, &INFO, sizeof(INFO));
					      }
			         } //end else
				
			  } //end if fd = server_socket

		   } //end if(FD_ISSET...)
		
		} //end while()
} //end main()

//******************************************************
//***      	SERVER SIDE SUB-ROUTINES             ***
//******************************************************

int PlayerByPort(unsigned int portnum, unsigned int players[])
{ //find the player number by the port number

for (int a=0; a < 8; a++)
	if (players[a] == portnum) return a;

return -1;
}

//*****************************************************
int FindOpenSlot(unsigned int players[])
{
for (int a=0; a < 8; a++)
        if (players[a] == 0) return a;
return -1;
}

//******************************************************

void Move(unsigned int intarray [81][81], unsigned int Players [9][2], int PlayerNumber, char direction)
{
        //know the move is legal

        int x=0; //temp store the player's location
        int y=0;
        GetPlayerLocation(Players[PlayerNumber][0], x, y);

        int oldx=x;
        int oldy=y;

                switch(direction)
                {
                        case 'w': x-=1; break;
                        case 's': x+=1; break;
                        case 'a': y-=1; break;
                        case 'd': y+=1; break;
                };

        CodePlayerLocation(Players[PlayerNumber][0], x, y);

        int mx, my;
        GetPlayerLocation(Players[8][0], mx, my);

        if(intarray[x][y]%PLAYER>0 || (x==mx && y==my))
                //if treasures or monsters
        {
                GetTreasures(intarray, Players, PlayerNumber);
                AttackMonsters(intarray, Players, PlayerNumber, oldx, oldy);
        }
}


//******************************************************
//******************************************************

void GetTreasures(unsigned int intarray[81][81],
	unsigned int Players[9][2], int PlayerNumber)
{
	int x=0; //temp store the player's location
        int y=0;
        GetPlayerLocation(Players[PlayerNumber][0], x, y);
	int THere[16]; //store treasures at this new location
	GetIntBits(intarray[x][y], THere);

	if(THere[13] && Players[PlayerNumber][1]%512<400)
	{
		intarray[x][y]-=FIRSTAID;
		Players[PlayerNumber][1]+=4;
		printf("Power up. ");
	}

	if(THere[6]||THere[7]||THere[8]||THere[9]||THere[10]||THere[11]||THere[12]||THere[13])
	{
		int TYour[16]; //Your tresures
		GetIntBits(Players[PlayerNumber][1], TYour);

		if(TYour[0]==0&&THere[6]==1)
		{
			intarray[x][y]-=RADIO;
			Players[PlayerNumber][1]+=32768;
			printf("Player now has a Radio. \n");
		}

		if(TYour[1]==0&&THere[7]==1)
		{
			intarray[x][y]-=LAMP;
			Players[PlayerNumber][1]+=16384;
			printf("Player now has a Lamp. \n");
		}

                if(TYour[2]==0&&THere[8]==1)
                {
                        intarray[x][y]-=OIL;
                        Players[PlayerNumber][1]+=8192;
                        printf("Player now has Oil. \n");
                }

                if(TYour[3]==0&&THere[9]==1)
                {
                        intarray[x][y]-=SCOUT;
                        Players[PlayerNumber][1]+=4096;
                        printf("Player now has Scouts. \n");
                }

                if(TYour[4]==0&&THere[10]==1)
                {
                        intarray[x][y]-=MESSENGER;
                        Players[PlayerNumber][1]+=2048;
                        printf("Player now has Messengers. \n");
                }

                if(TYour[5]==0&&THere[11]==1)
                {
                        intarray[x][y]-=SHIELD;
                        Players[PlayerNumber][1]+=1024;
                        printf("Player now has a Shield. \n");
                }

                if(TYour[6]==0&&THere[12]==1)
                {
                        intarray[x][y]-=LANCE;
                        Players[PlayerNumber][1]+=512;
                       printf("Player now has a Lance. \n");
                }
	}
}

//******************************************************
//******************************************************

int PlayerIsHere(unsigned int Players [9][2], int x, int y)
//if player is there or end of map
{
	if((x<0 || x>80) || (y<0 || y>80))
		return 1; //edge of map

	for(int i=0; i<8; i++)
	{
		int px, py;
		GetPlayerLocation(Players[i][0], px, py);
		if(px==x && py==y)
			return 1; //player is here
	}

	return 0;
}

//******************************************************
//******************************************************

void AttackMonsters(unsigned int intarray [81][81],
	unsigned int Players [9][2], int PlayerNumber, int oldx, int oldy)
{
        int x=0; //temp store the player's location
        int y=0;
        GetPlayerLocation(Players[PlayerNumber][0], x, y);

        int THave[16]; //store treasures at this new location
        GetIntBits(Players[PlayerNumber][1], THave);
        int HP=Players[PlayerNumber][1]%512;

	if(intarray[x][y]%4>1)//there are monsters
	{
		if(THave[6]==1) //you have a lance
		{
			if(THave[5]==1 && HP>2) //you have a shield
			{
				intarray[x][y]-=MONSTER;
				Players[PlayerNumber][1]-=2;
			}
                        else if(HP>5)//you have no shield
                        {
                                intarray[x][y]-=MONSTER;
                                Players[PlayerNumber][1]-=5;
                        }
			else
			{
				Players[PlayerNumber][1]-=HP;
				cout << "You are dead." << endl;
			}
		}

                else //you have no lance
                {
			int movex=x+(x-oldx);
			int movey=y+(y-oldy);

                        if(THave[5]==1 && HP>2) //you have a shield
                        {
                                intarray[x][y]-=MONSTER;

				//if the monster can move over (no M or P)
				if(intarray[movex][movey]%4<2)
					intarray[movex][movey]+=MONSTER;
				else
					Players[PlayerNumber][1]-=2;
                                Players[PlayerNumber][1]-=2;
                        }
                        else if(HP>5) //you have no shield
                        {
                                intarray[x][y]-=MONSTER;

                                //if the monster can move over (no M or P)
                                if(intarray[movex][movey]%4<2)
                                        intarray[movex][movey]+=MONSTER;
                                else
                                        Players[PlayerNumber][1]-=5;

                                Players[PlayerNumber][1]-=5;
                        }
			else
			{
				Players[PlayerNumber][1]-=HP;
				cout << "You are dead." << endl;
			}
                }
	}

	//test for SuperMonster
	int mx, my;
	GetPlayerLocation(Players[8][0], mx, my);
	if(mx==x && my==y)
	{
		int movex=x+(x-oldx);
                int movey=y+(y-oldy);

		//if players don't block, monster runs away
                if(THave[6]==1) //you have a lance
                {
                        if(THave[5]==1 && HP>4) //you have a shield
                                Players[PlayerNumber][1]-=4;

			else if(HP>10) //no shield but enough life
				Players[PlayerNumber][1]-=10;

                        else
                        {
                                Players[PlayerNumber][1]-=HP;
                                cout << "You are dead." << endl;
                        }

			if(!PlayerIsHere(Players, movex, movey))
                        {
			  CodePlayerLocation(Players[8][0],
			    movex, movey);

			  int Bits[16];
			  GetIntBits(intarray[x][y], Bits);

			  if(x<oldx && Bits[0]==0)
				{intarray[x][y]+=UP;
				 intarray[movex][movey]+=DOWN;}
			  if(x>oldx && Bits[1]==0)
				{intarray[x][y]+=DOWN;
				 intarray[movex][movey]+=UP;}
			  if(y<oldy && Bits[2]==0)
				{intarray[x][y]+=LEFT;
				 intarray[movex][movey]+=RIGHT;}
			  if(y>oldy && Bits[3]==0)
				{intarray[x][y]+=RIGHT;
				 intarray[movex][movey]+=LEFT;}
			}

			else if(x!=oldx)//if player moved vertically
			{
			  if(!PlayerIsHere(Players, x, y+1))
			    CodePlayerLocation(Players[8][0],
                              x, y+1);

			  else if(!PlayerIsHere(Players, x, y-1))
                            CodePlayerLocation(Players[8][0],
                              x, y-1);

			  else //SM can't move
			    Players[8][1]-=Players[8][1]%512;
			}

			else //if player moved horizontally
			{
                          if(!PlayerIsHere(Players, x+1, y))
                            CodePlayerLocation(Players[8][0],
                              x+1, y);

                          else if(!PlayerIsHere(Players, x-1, y))
                            CodePlayerLocation(Players[8][0],
                              x-1, y);

			  else //SM can't move
                            Players[8][1]-=Players[8][1]%512;
			}
		}

		else //you have no lance
		{
                	Players[PlayerNumber][1]-=HP;
            		cout << "You are dead." << endl;
		}
	}
}

//******************************************************
//******************************************************

void CreatePlayers(unsigned int Players[9][2])
{
	for(int i=0; i<8; i++)
	{
		int x=0; // rand()%81; 
		int y=0; // rand()%81; 
		CodePlayerLocation(Players[i][0], x, y);
			//players are randomly placed

		Players[i][1]=100;
			//players have no treasures, 50 HP

		// /*delete*/Players[i][1]+=65024;
	}

	CodePlayerLocation(Players[8][0], 40, 40); //put SM in center
	Players[8][1]=20; //SM starts with 100 HP
}

//******************************************************
//******************************************************

void InitServer(unsigned int intarray [81][81], unsigned int Players[9][2])
{
	CreateMatrix(intarray);
	CreatePlayers(Players);
}

//******************************************************
//******************************************************

double getCPUTime()
{
  struct timeval tv;
  gettimeofday(&tv, NULL);
  return tv.tv_usec;
}

//******************************************************
//******************************************************

void CreateMatrix(unsigned int intarray [81][81]) //intarray initially
{
	srand((unsigned int)getCPUTime());

        //update rules as you go to make paths open
	//make all closed to start
        int i,j;

        for(i=0; i<81; i++)
        {
                for(j=0; j<81; j++)
                {
                        intarray[i][j]=0;
			//assume all paths initially closed
                }
        }

	for(i=0; i<81; i++)
	{
		for(j=0; j<81; j++)
		{
		// *** Open connections for the 3x3's
			if(i%3==0 && j%3==0) //upper left of 3x3
			{
				if(rand()%2==1)
				{
					intarray[i][j]+=RIGHT;
					intarray[i][j+1]+=LEFT;
				}
				else
				{
					intarray[i][j]+=DOWN;
					intarray[i+1][j]+=UP;
				}
			}

			else if(i%3==0 && j%3==2) //upper right of 3x3
			{
				if(rand()%2==1)
				{
                                        intarray[i][j]+=LEFT;
                                        intarray[i][j-1]+=RIGHT;
                                }
                                else
                                {
                                        intarray[i][j]+=DOWN;
                                        intarray[i+1][j]+=UP;
                                }
			}

                        else if(i%3==2 && j%3==0) //lower left of 3x3
                        {
                                if(rand()%2==1)
                                {
                                        intarray[i][j]+=UP;
                                        intarray[i-1][j]+=DOWN;
                                }
                                else
                                {
                                        intarray[i][j]+=RIGHT;
                                        intarray[i][j+1]+=LEFT;
                                }
                        }

                        else if(i%3==2 && j%3==2) //lower right of 3x3
                        {
                                if(rand()%2==1)
                                {
                                        intarray[i][j]+=UP;
                                        intarray[i-1][j]+=DOWN;
                                }
                                else
                                {
                                        intarray[i][j]+=LEFT;
                                        intarray[i][j-1]+=RIGHT;
                                }
                        }

                        else if(i%3==1 && j%3==1) //middle of 3x3
                        {
				//open up
                                intarray[i][j]+=UP;
                                intarray[i-1][j]+=DOWN;

				//open down
                                intarray[i][j]+=DOWN;
                                intarray[i+1][j]+=UP;

				//open left
                                intarray[i][j]+=LEFT;
                                intarray[i][j-1]+=RIGHT;

				//open right
                                intarray[i][j]+=RIGHT;
                                intarray[i][j+1]+=LEFT;
                        }

		// *** Open connections for the 9x9's
			if(i%9==2 && j%9==2) //ul of 9x9, lr of 3x3
			{
				int temp=rand()%3;
				intarray[i-temp][j]+=RIGHT;
				intarray[i-temp][j+1]+=LEFT;

				temp=rand()%3;
				intarray[i][j-temp]+=DOWN;
				intarray[i+1][j-temp]+=UP;
			}

                        else if(i%9==2 && j%9==6) //ur of 9x9, ll of 3x3
                        {
                                int temp=rand()%3;
                                intarray[i-temp][j]+=LEFT;
                                intarray[i-temp][j-1]+=RIGHT;

                                temp=rand()%3;
                                intarray[i][j+temp]+=DOWN;
                                intarray[i+1][j+temp]+=UP;
                        }

                        else if(i%9==6 && j%9==2) //ll of 9x9, ur of 3x3
                        {
                                int temp=rand()%3;
                                intarray[i+temp][j]+=RIGHT;
                                intarray[i+temp][j+1]+=LEFT;

                                temp=rand()%3;
                                intarray[i][j-temp]+=UP;
                                intarray[i-1][j-temp]+=DOWN;
                        }

                        else if(i%9==6 && j%9==6) //lr of 9x9, ul of 3x3
                        {
                                int temp=rand()%3;
                                intarray[i+temp][j]+=LEFT;
                                intarray[i+temp][j-1]+=RIGHT;

                                temp=rand()%3;
                                intarray[i][j+temp]+=UP;
                                intarray[i-1][j+temp]+=DOWN;
                        }

                        else if(i%9==4 && j%9==4) //mm of 9x9, mm of 3x3
                        {
                                int temp=rand()%4;

				if(temp==0)//connect upwards
				{
                                	intarray[i-1][j]+=UP;
                                	intarray[i-2][j]+=DOWN;
				}

				else if(temp==1)//connect down
				{
                                	intarray[i+1][j]+=DOWN;
                                	intarray[i+2][j]+=UP;
				}

                                else if(temp==2)//connect left
                                {
                                        intarray[i][j-1]+=LEFT;
                                        intarray[i][j-2]+=RIGHT;
                                }

                                else if(temp==3)//connect right
                                {
                                        intarray[i][j+1]+=RIGHT;
                                        intarray[i][j+2]+=LEFT;
                                }
			}


		// *** Open connections for the 27x27's
			if(i%27==8 && j%27==8)
			{
				if(rand()%2==1)
				{
					int temp=rand()%9;
					intarray[i-temp][j]+=RIGHT;
					intarray[i-temp][j+1]+=LEFT;
				}
				else
				{
					int temp=rand()%9;
					intarray[i][j-temp]+=DOWN;
					intarray[i+1][j-temp]+=UP;
				}
                        }

                        else if(i%27==8 && j%27==18)
                        {
				if(rand()%2==1)
				{
                                	int temp=rand()%9;
                                	intarray[i-temp][j]+=LEFT;
                                	intarray[i-temp][j-1]+=RIGHT;
				}
				else
				{
                                	int temp=rand()%9;
                                	intarray[i][j+temp]+=DOWN;
                                	intarray[i+1][j+temp]+=UP;
				}
                        }

                        else if(i%27==18 && j%27==8)
                        {
				if(rand()%2==1)
				{
                                	int temp=rand()%9;
                                	intarray[i+temp][j]+=RIGHT;
                                	intarray[i+temp][j+1]+=LEFT;
				}
				else
				{
                                	int temp=rand()%9;
                                	intarray[i][j-temp]+=UP;
                                	intarray[i-1][j-temp]+=DOWN;
				}
                        }

                        else if(i%27==18 && j%27==18)
                        {
				if(rand()%2==1)
				{
                                	int temp=rand()%9;
                                	intarray[i+temp][j]+=LEFT;
                                	intarray[i+temp][j-1]+=RIGHT;
				}
				else
				{
                                	int temp=rand()%9;
                                	intarray[i][j+temp]+=UP;
                                	intarray[i-1][j+temp]+=DOWN;
				}
                        }

                        else if(i%27==9 && j%27==9) //ul of mm
                        {
                                int temp=rand()%9;
                                intarray[i+temp][j]+=LEFT;
                                intarray[i+temp][j-1]+=RIGHT;

                                temp=rand()%9;
                                intarray[i][j+temp]+=UP;
                                intarray[i-1][j+temp]+=DOWN;

                                temp=rand()%9;
                                intarray[i+temp][j+8]+=RIGHT;
                                intarray[i+temp][j+9]+=LEFT;

                                temp=rand()%9;
                                intarray[i+8][j+temp]+=DOWN;
                                intarray[i+9][j+temp]+=UP;
                        }

		// *** Open connections for the 81x81 !!!!!!!!
			if(i%81==26 && j%81==26)
                        {
                                int temp=rand()%27;
                                intarray[i-temp][j]+=RIGHT;
                                intarray[i-temp][j+1]+=LEFT;

                                temp=rand()%27;
                                intarray[i][j-temp]+=DOWN;
                                intarray[i+1][j-temp]+=UP;
                        }

                        else if(i%81==26 && j%81==54)
                        {
                                int temp=rand()%27;
                                intarray[i-temp][j]+=LEFT;
                                intarray[i-temp][j-1]+=RIGHT;

                                temp=rand()%27;
                                intarray[i][j+temp]+=DOWN;
                                intarray[i+1][j+temp]+=UP;
                        }

                        else if(i%81==54 && j%81==26)
                        {
                                int temp=rand()%27;
                                intarray[i+temp][j]+=RIGHT;
                                intarray[i+temp][j+1]+=LEFT;

                                temp=rand()%27;
                                intarray[i][j-temp]+=UP;
                                intarray[i-1][j-temp]+=DOWN;
                        }

                        else if(i%81==54 && j%81==54)
                        {
                                int temp=rand()%27;
                                intarray[i+temp][j]+=LEFT;
                                intarray[i+temp][j-1]+=RIGHT;

                                temp=rand()%27;
                                intarray[i][j+temp]+=UP;
                                intarray[i-1][j+temp]+=DOWN;
                        }

			else if(i%81==40 && j%81==40)
                        {
                                int temp=rand()%4;

                                if(temp==0)//connect upwards
                                {
                                        intarray[i-13][j]+=UP;
                                        intarray[i-14][j]+=DOWN;
                                }

                                else if(temp==1)//connect down
                                {
                                        intarray[i+13][j]+=DOWN;
                                        intarray[i+14][j]+=UP;
                                }

                                else if(temp==2)//connect left
                                {
                                        intarray[i][j-13]+=LEFT;
                                        intarray[i][j-14]+=RIGHT;
                                }

                                else if(temp==3)//connect right
                                {
                                        intarray[i][j+13]+=RIGHT;
                                        intarray[i][j+14]+=LEFT;
                                }
                        }

		// *** Add Treasures
			if(i%7==4 && j%7==5) intarray[i][j]+=RADIO;
			if(i%8==5 && j%8==2) intarray[i][j]+=LAMP;
			if(i%15==7 && j%15==4) intarray[i][j]+=OIL;
			if(i%29==23 && j%29==13) intarray[i][j]+=SCOUT;
			if(i%12==6 && j%12==8) intarray[i][j]+=MESSENGER;
			if(i%9==3 && j%9==6) intarray[i][j]+=SHIELD;
			if(i%13==7 && j%13==5) intarray[i][j]+=LANCE;
			if(i%19==0 && j%19==2) intarray[i][j]+=FIRSTAID;

		// *** Add Monsters hehe
			if(i%8==6 && j%7==6) intarray[i][j]+=MONSTER;
		}
	}	
}

//******************************************************
//******************************************************

void GetPlayerLocation(unsigned int code, int &x, int &y)
{
	x=0;
	y=0;

if (code >= 32768) code -= 32768;

	//Get the X
	if (code >= 16384){x+=64;code-=16384;}
	if (code >= 8192) {x+=32;code-=8192; }
	if (code >= 4096) {x+=16;code-=4096; }
	if (code >= 2048) {x+=8; code-=2048; }
	if (code >= 1024) {x+=4; code-=1024; }
	if (code >= 512)  {x+=2; code-=512;  }
	if (code >= 256)  {x+=1; code-=256;  }

	//Get the Y
 if (code >= 128) code -= 128;
	if (code >= 64){y+=64;code-=64;}
        if (code >= 32){y+=32;code-=32;}
        if (code >= 16){y+=16;code-=16;}
        if (code >= 8) {y+=8; code-=8; }
        if (code >= 4) {y+=4; code-=4; }
        if (code >= 2) {y+=2; code-=2; }
        if (code >= 1) {y+=1; code-=1; }

}

//******************************************************
//******************************************************

void CodePlayerLocation(unsigned int &code, int x, int y)
{
	code=0;

	//Code the X
	if (x >= 64){code+=16384;x-=64;}
	if (x >= 32){code+=8192; x-=32;}
	if (x >= 16){code+=4096; x-=16;}
	if (x >= 8) {code+=2048; x-=8; }
	if (x >= 4) {code+=1024; x-=4; }
	if (x >= 2) {code+=512;  x-=2; }
	if (x >= 1) {code+=256;  x-=1; }

        //Code the Y
        if (y >= 64){code+=64;y-=64;}
        if (y >= 32){code+=32;y-=32;}
        if (y >= 16){code+=16;y-=16;}
        if (y >= 8) {code+=8; y-=8; }
        if (y >= 4) {code+=4; y-=4; }
        if (y >= 2) {code+=2; y-=2; }
        if (y >= 1) {code+=1; y-=1; }
}

//******************************************************
//******************************************************

void GetIntBits(unsigned int input, int Bits[16])
{
	unsigned int temp=input;

	for(int i=0; i<16; i++){Bits[i]=0;}

	if (temp >= 32768){Bits[0]+=1;  temp-=32768;}
        if (temp >= 16384){Bits[1]+=1;  temp-=16384;}
        if (temp >= 8192) {Bits[2]+=1;  temp-=8192; }
        if (temp >= 4096) {Bits[3]+=1;  temp-=4096; }
        if (temp >= 2048) {Bits[4]+=1;  temp-=2048; }
        if (temp >= 1024) {Bits[5]+=1;  temp-=1024; }
        if (temp >= 512)  {Bits[6]+=1;  temp-=512;  }
        if (temp >= 256)  {Bits[7]+=1;  temp-=256;  }
        if (temp >= 128)  {Bits[8]+=1;  temp-=128;  }
        if (temp >= 64)   {Bits[9]+=1;  temp-=64;   }
        if (temp >= 32)   {Bits[10]+=1; temp-=32;   }
        if (temp >= 16)   {Bits[11]+=1; temp-=16;   }
        if (temp >= 8)    {Bits[12]+=1; temp-=8;    }
        if (temp >= 4)    {Bits[13]+=1; temp-=4;    }
        if (temp >= 2)    {Bits[14]+=1; temp-=2;    }
        if (temp >= 1)    {Bits[15]+=1; temp-=1;    }
}
