       //================\\
      //  Kevin Peterson  \\
     //  Brandon S. Parker \\
    //Cheryl-Annette Kincaid\\
   //      CSCI 3780.001     \\
  //      April 29, 2003      \\
 //        labrynth.cc        \\
//==============================\\
//********************************************************************
//*                      Project #2:                                 *
//*                                                                  *
//* Source files:  labrynth.cc, labrynthd.cc, Queue.cpp              *
//*                                                                  *
//* Input: console and socket                                        *
//*                                                                  *
//* Output: console and socket                                       *
//*                                                                  *
//* Compile with: make                                               *
//*                                                                  *
//* Objective: provides an interactive network game that supports    *
//*            up to eight players                                   *
//*                                                                  *
//* Authors:                                                         *
//*  Brandon S. Parker, Kevin Peterson, Cheryl-Annet Kincaid         *
//*  (c) 2003                                                        *
//*                                                                  *
//********************************************************************


/*
	Players[9][2]

		Players[i][0]
		01234567 01234567
		 x        y

		Players[i][1]
		Treasures Hit Points
		0123456   701234567
		RLOSHGA   HP-------

	PlayerNumber 0-8

		0-7 = Players 1-8
		8   = SuperMonster

	intarray[81][81]

		intarray[i][i]
		Directions Players Treasures Monsters Visible
		0123       45      67012345  6        7
		UDLR       YP      RLOSHGA+  M        V

	chararray[324][324]

		x*4 and y*4

		Initial Setup:
		  0123
		0 ####
		1 #  #
		2 #  #
		3 ####

		Final Display:
	          0123
       		0 #UU#
        	1 LYPR
        	2 LTMR
        	3 #DD#
*/

#include <iostream.h>
#include <string>
#include <stdio.h>
#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <cstdlib>
#include <sys/time.h>
#include <curses.h>
#include <sys/resource.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "gameserver.h"
#include "Queue.h"

#define UP 32768
#define DOWN 16384
#define LEFT 8192
#define RIGHT 4096
#define YOU 2048
#define PLAYER 1024
#define RADIO 512
#define LAMP 256
#define OIL 128
#define SCOUT 64
#define MESSENGER 32
#define SHIELD 16
#define LANCE 8
#define FIRSTAID 4
#define MONSTER 2
#define WALLS 219
#define HIDDEN 35

// *** Client Prototypes
void RunClient(unsigned int intarray[81][81], char chararray [324][324],
        unsigned int Players [9][2], int PlayerNumber, char Chat [80]);
void DecodeMatrix(unsigned int intarray [81][81], char chararray[324][324]);
void DisplayMatrix(char chararray[324][324], unsigned int Players[9][2],
	int PlayerNumber);
void AddChatMessage(char Chat [80], unsigned int Players [9][2], int PlayerNumber);
void CodePlayerLocation(unsigned int &code, int x, int y);
void AddVisibility(unsigned int intarray[81][81], unsigned int Players[9][2],
	int PlayerNumber);
void AddPlayerVisibility(unsigned int intarray[81][81], unsigned int Players[2]);
int TestMove(unsigned int intarray [81][81], unsigned int Players [9][2],
        int PlayerNumber, char direction);
void DisplayHelp();

double getCPUTime();
void GetIntBits(unsigned int input, int Bits[16]);
void GetPlayerLocation(unsigned int code, int &x, int &y);
// *** Both???
//void GetIntBits(unsigned int input, int Bits[16]);
//double getCPUTime();


bool DEBUG = true;

queueClass ChatQ;
bool initiate =0;

struct recvpacket
{
int playernum;
char chat[80];
unsigned int players[9][2];
unsigned int map[81][81];
};

struct sendpacket
{
char command;
int playernum;
char chat[80];
};


void main(int argv, char *argc[])
{

	sendpacket SNDPCK;
	recvpacket RCVPCK;
	
        srand((unsigned int)getCPUTime());

        //unsigned int intarray [81][81]; //stored on server
        //unsigned int tempintarray[81][81]; //local copy

        char chararray [324][324]; //only local
        //int PlayerNumber=rand()%8; //handled by server
        //unsigned int Players [9][2]; //8 players 0..7

	system("clear");

        //InitServer(intarray, Players); //create matrix and players

        //tempintarray=intarray;

	int sockfd;
	int len;
	int result;
	char NAME[10];
	struct sockaddr_in address;

	sockfd = socket(AF_INET, SOCK_STREAM, 0);

	address.sin_family = AF_INET;
        address.sin_addr.s_addr = inet_addr("129.120.36.71"); // csp07
        address.sin_port = 9788; // Take your pick
        len = sizeof(address);

	if (argv < 2)
		{
		cout<<"Usage: "<<argc[0]<<" <server IP> [<server port>]"<<endl;
		exit(1);
		}
	if (argv > 1)
		address.sin_addr.s_addr = inet_addr(argc[1]);
	if (argv > 2)
		address.sin_port = atoi(argc[2]);


        result = connect(sockfd, (struct sockaddr *)&address, len);

        if (result == -1)
                {
                cout<<"Unable to connect to the server - server either down or full. Try back later."<<endl;
                exit(1);
                }
	
	cout<<"So, you want to journey into the depths of the Labrynth, eh?"<<endl;
	cout<<"You think you're brave enough to face the vicious Cook-E monster??"<<endl;
	cout<<"Well lad, its your life you're risking. By what name shalt thou be known?\n>>";
	cin>>NAME;

	cout<<"Very well, "<<NAME<<", into to Labrynth with ya! Oh, and take my"<<endl;
	cout<<"advice. If you smell chips-ahoy, RUN! especially if you are alone in there."<<endl;
	cout<<"The only way to destroy the feind that lurks below is to corner or surround him."<<endl;
	cout<<"If you try to take him on alone, thou shalt surely be smotten!"<<endl;
	cout<<"Keep an eye out for treasures too. There are items in the shadows of the"<<endl;
	cout<<"labrynth that will help you on your quest! Good-Luck!"<<endl<<endl;
	//sleep(1);
	
		
	SNDPCK.command = '|';
	SNDPCK.playernum = -1;
	strcpy(SNDPCK.chat, "   ");
	
	write(sockfd, &SNDPCK, sizeof(SNDPCK));
	char buffer[26400];
	for(int i=0;i<26400;i++){buffer[i]=66;}
	ssize_t n = 0;
	ssize_t total = 0;
	while (total < sizeof(RCVPCK))  //26244)//< sizeof(RCVPCK))

	{ //*** Loop reads until all packets for the struct are obtained:
		n = read(sockfd, &buffer[total], 1);
		total += n;

		if (n < 0)
		{
			cout<<endl<<"Thou hast been smotten into a sugarcookie!"<<endl;
                        exit(1);
                }
	}	


	memcpy(&RCVPCK.playernum, &buffer, sizeof(RCVPCK.playernum));
	memcpy(&RCVPCK.chat, &buffer[sizeof(RCVPCK.playernum)],sizeof(RCVPCK.chat));
	memcpy(&RCVPCK.players, &buffer[sizeof(RCVPCK.playernum) + sizeof(RCVPCK.chat)],sizeof(RCVPCK.players));
	memcpy(&RCVPCK.map, &buffer[sizeof(RCVPCK.playernum) + sizeof(RCVPCK.chat) + sizeof(RCVPCK.players)],sizeof(RCVPCK.map));

	//	if (DEBUG) cout<<"Player Num: "<<RCVPCK.playernum<<endl;
        //      if (DEBUG) cout<<"Chat: "<<RCVPCK.chat<<endl;
        //      if (DEBUG) cout<<"size of array: "<<sizeof(RCVPCK)<<endl;


	

	SNDPCK.playernum = RCVPCK.playernum;


        RunClient(RCVPCK.map, chararray, RCVPCK.players, SNDPCK.playernum, RCVPCK.chat);

        int yescontinue=1;

        fd_set rfds;
        struct timeval tv;
        int retval;

        /* Watch stdin (fd 0) to see when it has input. */
        FD_ZERO(&rfds);
        FD_SET(0, &rfds);
	FD_SET(sockfd, &rfds);

        /* Wait a second. */
        tv.tv_sec = 0;
        tv.tv_usec = 1;

        while(yescontinue)
        {
	        retval = select(FD_SETSIZE, &rfds, NULL, NULL, &tv);
	        /* Don't rely on the value of tv now! */

	        if (FD_ISSET(0, &rfds))
                {
	                /* FD_ISSET(0, &rfds) will be true. */

	                cin >> SNDPCK.command; //direction

	                int legalmove=0;

	                legalmove=TestMove(RCVPCK.map,
					RCVPCK.players,SNDPCK.playernum, SNDPCK.command);

	                if(legalmove==1)
        	                //call server will have intarray and Players
                	{
				char bleh[80];
				strcpy(bleh,"don't print this");
				memcpy(&SNDPCK.chat,&bleh,sizeof(SNDPCK.chat));
	                        if(SNDPCK.command == 't')
				{
                                	char message[66];
                                	char temp[80];
                                	char blah[3];
                                	strcpy(temp, "");
                                	strcpy(blah, ": ");
                                	cin.getline(message,66,'\n');
                                	strcat(temp,NAME);
                                	strcat(temp,blah);
                                	strcat(temp,message);
                                	memcpy(&SNDPCK.chat, &temp,sizeof(SNDPCK.chat));

	                                if (DEBUG) cout << "sendpck: " << SNDPCK.chat << endl;
        	                }


                	        //Move(intarray, Players, PlayerNumber, direction);
                        	write(sockfd, &SNDPCK, sizeof(SNDPCK));

				int test=-1;

				//you know that at least your message will come
                                while(test!=SNDPCK.playernum)
                                {
                                        total = 0;

                                        while (total < sizeof(RCVPCK))
                                        { //*** Loop reads until gets all packets

                                                n = read(sockfd, &buffer[total], 1);
                                                total += n;

                                                if (n < 0)
                                                {
                                                        cout<<endl<<"Thou hast been smotten"
                                                        <<" into a sugarcookie!"<<endl;
                                                        exit(1);
                                                }
                                        }

                                        //*** test is now the player associated with the move
                                        memcpy(&test, &buffer, sizeof(RCVPCK.playernum));
                                        memcpy(&RCVPCK.chat, &buffer[sizeof(RCVPCK.playernum)],sizeof(RCVPCK.chat));
                                        memcpy(&RCVPCK.players, &buffer[sizeof(RCVPCK.playernum)
                                                + sizeof(RCVPCK.chat)],sizeof(RCVPCK.players));
                                        memcpy(&RCVPCK.map, &buffer[sizeof(RCVPCK.playernum)
                                                + sizeof(RCVPCK.chat) + sizeof(RCVPCK.players)],sizeof(RCVPCK.map));


					if(RCVPCK.players[RCVPCK.playernum][1]%512==0)
                                                yescontinue=0;

                                        if(RCVPCK.players[8][1]%512==0)
                                        {
                                                cout<<"You WIN!!!"<<endl;
                                                yescontinue=0;
                                        }

                                        else
                                        {
                                                RunClient(RCVPCK.map, chararray, RCVPCK.players,
							SNDPCK.playernum, RCVPCK.chat);
                                        }
				}
			}

	                else if(legalmove==2)
	                        yescontinue=0;
                }

		//now look for server updates 
		else if (retval)
                {

	                total = 0;

	                while (total < sizeof(RCVPCK))
	                { //*** Loop reads until all packets for the struct are obtained:

	                	n = read(sockfd, &buffer[total], 1);
	                        total += n;

	                        if (n < 0)
	                        {
		                        cout<<endl<<"Thou hast been smotten into a sugarcookie!"<<endl;
	                                exit(1);
	                        }
	                }
			
			//*** We dont want this really...
		        //memcpy(&RCVPCK.playernum, &buffer, sizeof(RCVPCK.playernum));
		        memcpy(&RCVPCK.chat, &buffer[sizeof(RCVPCK.playernum)],sizeof(RCVPCK.chat));
		        memcpy(&RCVPCK.players, &buffer[sizeof(RCVPCK.playernum)
		                + sizeof(RCVPCK.chat)],sizeof(RCVPCK.players));
		        memcpy(&RCVPCK.map, &buffer[sizeof(RCVPCK.playernum)
		                + sizeof(RCVPCK.chat) + sizeof(RCVPCK.players)],sizeof(RCVPCK.map));

	                if(RCVPCK.players[RCVPCK.playernum][1]%512==0)
	                        yescontinue=0;

	                if(RCVPCK.players[8][1]%512==0)
	                {
	                        cout<<"You WIN!!!"<<endl;
	                        yescontinue=0;
	                }

	                else
			{
	                        RunClient(RCVPCK.map, chararray, RCVPCK.players, SNDPCK.playernum, RCVPCK.chat);
	                }
		}

	        /* Watch stdin (fd 0) to see when it has input. */
	        FD_ZERO(&rfds);
	        FD_SET(0, &rfds);
	        FD_SET(sockfd, &rfds);

                /* Wait a second. */
                tv.tv_sec = 0;
                tv.tv_usec = 1;
	}
}

//*********************************************************
//***           SUB-ROUNTINE FROM SERVER                ***
//*********************************************************

double getCPUTime()
{
  struct timeval tv;
  gettimeofday(&tv, NULL);
  return tv.tv_usec;
}

//**********************

void CodePlayerLocation(unsigned int &code, int x, int y)
{
        code=0;

        //Code the X
        if (x >= 64){code+=16384;x-=64;}
        if (x >= 32){code+=8192; x-=32;}
        if (x >= 16){code+=4096; x-=16;}
        if (x >= 8) {code+=2048; x-=8; }
        if (x >= 4) {code+=1024; x-=4; }
        if (x >= 2) {code+=512;  x-=2; }
        if (x >= 1) {code+=256;  x-=1; }

        //Code the Y
        if (y >= 64){code+=64;y-=64;}
        if (y >= 32){code+=32;y-=32;}
        if (y >= 16){code+=16;y-=16;}
        if (y >= 8) {code+=8; y-=8; }
        if (y >= 4) {code+=4; y-=4; }
        if (y >= 2) {code+=2; y-=2; }
        if (y >= 1) {code+=1; y-=1; }
}

//******************************************************

void GetIntBits(unsigned int input, int Bits[16])
{
        unsigned int temp=input;

        for(int i=0; i<16; i++){Bits[i]=0;}

        if (temp >= 32768){Bits[0]+=1;  temp-=32768;}
        if (temp >= 16384){Bits[1]+=1;  temp-=16384;}
        if (temp >= 8192) {Bits[2]+=1;  temp-=8192; }
        if (temp >= 4096) {Bits[3]+=1;  temp-=4096; }
        if (temp >= 2048) {Bits[4]+=1;  temp-=2048; }
        if (temp >= 1024) {Bits[5]+=1;  temp-=1024; }
        if (temp >= 512)  {Bits[6]+=1;  temp-=512;  }
        if (temp >= 256)  {Bits[7]+=1;  temp-=256;  }
        if (temp >= 128)  {Bits[8]+=1;  temp-=128;  }
        if (temp >= 64)   {Bits[9]+=1;  temp-=64;   }
        if (temp >= 32)   {Bits[10]+=1; temp-=32;   }
        if (temp >= 16)   {Bits[11]+=1; temp-=16;   }
        if (temp >= 8)    {Bits[12]+=1; temp-=8;    }
        if (temp >= 4)    {Bits[13]+=1; temp-=4;    }
        if (temp >= 2)    {Bits[14]+=1; temp-=2;    }
        if (temp >= 1)    {Bits[15]+=1; temp-=1;    }
}

//*******************************************************

void GetPlayerLocation(unsigned int code, int &x, int &y)
{
        x=0;
        y=0;

if (code >= 32768) code -= 32768;
        //Get the X
        if (code >= 16384){x+=64;code-=16384;}
        if (code >= 8192) {x+=32;code-=8192; }
        if (code >= 4096) {x+=16;code-=4096; }
        if (code >= 2048) {x+=8; code-=2048; }
        if (code >= 1024) {x+=4; code-=1024; }
        if (code >= 512)  {x+=2; code-=512;  }
        if (code >= 256)  {x+=1; code-=256;  }

        //Get the Y
 if (code >= 128) code -= 128;
        if (code >= 64){y+=64;code-=64;}
        if (code >= 32){y+=32;code-=32;}
        if (code >= 16){y+=16;code-=16;}
        if (code >= 8) {y+=8; code-=8; }
        if (code >= 4) {y+=4; code-=4; }
        if (code >= 2) {y+=2; code-=2; }
        if (code >= 1) {y+=1; code-=1; }

}


//*********************************************************
//*** 		SUB-ROUNTINE				***
//*********************************************************

void AddPlayers(unsigned int intarray[81][81], unsigned int Players [9][2],
	int PlayerNumber)
{

	for(int i=0; i<8; i++)
	{
		if(PlayerNumber==i)
		{
			int x = 0;
			int y = 0;

			GetPlayerLocation(Players[i][0], x, y);
			intarray[x][y]+=YOU;
		}

		else
		{
			int x=0, y=0;
			GetPlayerLocation(Players[i][0], x, y);

			int GetBits[16];
			GetIntBits(intarray[x][y],GetBits);
			if(GetBits[5]==0)
				intarray[x][y]+=PLAYER;
		}
	}
}

void AddPlayerVisibility(unsigned int intarray[81][81], unsigned int Players[2])
{
	int x,y;
	GetPlayerLocation(Players[0], x, y);
	int Treasures[16];
	GetIntBits(Players[1],Treasures);

	if(Treasures[1]==1)
	{
	  if(Treasures[2]==1)
	  {
	    if(Treasures[3]==1)
	    {


	      for(int i=x-4; i<=x+4; i++)
		for(int j=y-4; j<=y+4; j++)

		  //if in matrix and not visible
		  if(i>=0 && i<81 && j>=0 && j<81)
		    if(intarray[i][j]%2==0)
		      intarray[i][j]+=1;
	    }
	    else
	    {
	      for(int i=x-3; i<=x+3; i++)
                for(int j=y-3; j<=y+3; j++)
                  //if in matrix and not visible
                  if(i>=0 && i<81 && j>=0 && j<81)
                    if(intarray[i][j]%2==0)
                      intarray[i][j]+=1;
	    }
	  }
	  else
	  {
	    for(int i=x-2; i<=x+2; i++)
              for(int j=y-2; j<=y+2; j++)
                //if in matrix and not visible
                if(i>=0 && i<81 && j>=0 && j<81)
                  if(intarray[i][j]%2==0)
                    intarray[i][j]+=1;
          }
	}
	else
	{
	  for(int i=x-1; i<=x+1; i++)
            for(int j=y-1; j<=y+1; j++)
              //if in matrix and not visible
              if(i>=0 && i<81 && j>=0 && j<81)
                if(intarray[i][j]%2==0)
                  intarray[i][j]+=1;
	}
}

void AddVisibility(unsigned int intarray[81][81], unsigned int Players[9][2],
        int PlayerNumber)
{
	int Treasures[16];
	GetIntBits(Players[PlayerNumber][1], Treasures);

	if(Treasures[4]==1)
		for(int i=0; i<8; i++)
			AddPlayerVisibility(intarray, Players[i]);

	else
		AddPlayerVisibility(intarray, Players[PlayerNumber]);
}

void RunClient(unsigned int intarray[81][81], char chararray [324][324],
	unsigned int Players [9][2], int PlayerNumber, char Chat [80])
{
	AddPlayers(intarray, Players, PlayerNumber);
	AddVisibility(intarray, Players, PlayerNumber);
	DecodeMatrix(intarray, chararray);
	AddChatMessage(Chat, Players, PlayerNumber);
        DisplayMatrix(chararray, Players, PlayerNumber);
}

int TestMove(unsigned int intarray [81][81], unsigned int Players [9][2],
	int PlayerNumber, char direction)
{
        int x=0; //temp store your location
        int y=0;

        GetPlayerLocation(Players[PlayerNumber][0], x, y);

	int GetBits[16];

	GetIntBits(intarray[x][y], GetBits);
                switch(direction)
                {
                        case 'w':if(GetBits[0]) {return 1;} return 0;
                        case 's':if(GetBits[1]) {return 1;} return 0;
                        case 'a':if(GetBits[2]) {return 1;} return 0;
                        case 'd':if(GetBits[3]) {return 1;} return 0;
                        case 'q':                return 2;
			case 't':GetIntBits(Players[PlayerNumber][1],GetBits);
				 if(GetBits[0])	{return 1;} return 0;
			case 'h':DisplayHelp();  return 1;
                };
        return 0;
}

void AddChatMessage(char chat [80], unsigned int Players [9][2], int PlayerNumber){
	bool success;
	int GetBits[16];
	GetIntBits(Players[PlayerNumber][1],GetBits);
	if(GetBits[0])	{
		char temp[80];

		if(!initiate){
			for(int count=0;count<8;count++){
                               	char temp[80];
				strcpy(temp,"   ");
				ChatQ.QueueInsert(temp, success);
			}
		
			initiate = 1;
		}
		

		if(strcmp(chat,"don't print this")!=0){
		
			ChatQ.QueueInsert(chat, success);
			ChatQ.QueueDelete(temp, success);
	//		if (DEBUG) cout << "just added " << chat;
		}
	}

}

void DisplayMatrix(char chararray [324][324], unsigned int Players [9][2],
	int PlayerNumber)
{
	
	int x=0;
	int y=0;
	GetPlayerLocation(Players[PlayerNumber][0], x, y);

	int newx=x;
	int newy=y;

	if(x<4)	newx=4;
	if(y<4)	newy=4;
	if(x>76)newx=76;
	if(y>76)newy=76;


	int YourHP=Players[PlayerNumber][1]%512;
	int YourObjects[16];

	//Add SM
	int mx, my;
	GetPlayerLocation(Players[8][0], mx, my);
	chararray[mx*4+2][my*4+2]='C';


        GetIntBits(Players[PlayerNumber][1]-YourHP, YourObjects);

	int i,j;
	char chat[80];
	bool success;
	system("clear");
	cout<<endl;

	int linecount=0;

	for(i=(newx-4)*4; i<(newx+5)*4; i++)
	{
		for(j=(newy-4)*4; j<(newy+5)*4; j++)
			cout<<chararray [i][j];

		if(linecount==0)
			cout<<"  HP: " << YourHP*5;
		else if(linecount==1)
		{
			cout<<"  Treasures: ";
			if(YourObjects[0]) cout<<"R "; else cout<<"  ";
			if(YourObjects[1]) cout<<"L "; else cout<<"  ";
                        if(YourObjects[2]) cout<<"O "; else cout<<"  ";
                        if(YourObjects[3]) cout<<"S "; else cout<<"  ";
                        if(YourObjects[4]) cout<<"H "; else cout<<"  ";
                        if(YourObjects[5]) cout<<"G "; else cout<<"  ";
                        if(YourObjects[6]) cout<<"A "; else cout<<"  ";
		}

		else if(linecount==2)
			cout<<"  Your Location: X: "<<x<<"  Y: "<<y;

		else if(linecount==3 && YourObjects[4])
		{
			int p=linecount-3;
			if(p!=PlayerNumber)
			{
				int tempx, tempy;
				GetPlayerLocation(Players[p][0],
					tempx, tempy);
				cout<<"  "<<p<<" ("<<tempx<<","
				    <<tempy<<")";
			}
		}

                else if(linecount==4 && YourObjects[4])
                {
                        int p=linecount-3;
                        if(p!=PlayerNumber)
                        {
                                int tempx, tempy;
                                GetPlayerLocation(Players[p][0],
                                        tempx, tempy);
                                cout<<"  "<<p<<" ("<<tempx<<","
                                    <<tempy<<")";
                        }
                }

                else if(linecount==5 && YourObjects[4])
                {
                        int p=linecount-3;
                        if(p!=PlayerNumber)
                        {
                                int tempx, tempy;
                                GetPlayerLocation(Players[p][0],
                                        tempx, tempy);
                                cout<<"  "<<p<<" ("<<tempx<<","
                                    <<tempy<<")";
                        }
                }

                else if(linecount==6 && YourObjects[4])
                {
                        int p=linecount-3;
                        if(p!=PlayerNumber)
                        {
                                int tempx, tempy;
                                GetPlayerLocation(Players[p][0],
                                        tempx, tempy);
                                cout<<"  "<<p<<" ("<<tempx<<","
                                    <<tempy<<")";
                        }
                }

                else if(linecount==7 && YourObjects[4])
                {
                        int p=linecount-3;
                        if(p!=PlayerNumber)
                        {
                                int tempx, tempy;
                                GetPlayerLocation(Players[p][0],
                                        tempx, tempy);
                                cout<<"  "<<p<<" ("<<tempx<<","
                                    <<tempy<<")";
                        }
                }

                else if(linecount==8 && YourObjects[4])
                {
                        int p=linecount-3;
                        if(p!=PlayerNumber)
                        {
                                int tempx, tempy;
                                GetPlayerLocation(Players[p][0],
                                        tempx, tempy);
                                cout<<"  "<<p<<" ("<<tempx<<","
                                    <<tempy<<")";
                        }
                }

                else if(linecount==9 && YourObjects[4])
                {
                        int p=linecount-3;
                        if(p!=PlayerNumber)
                        {
                                int tempx, tempy;
                                GetPlayerLocation(Players[p][0],
                                        tempx, tempy);
                                cout<<"  "<<p<<" ("<<tempx<<","
                                    <<tempy<<")";
                        }
                }

                else if(linecount==10 && YourObjects[4])
                {
                        int p=linecount-3;
                        if(p!=PlayerNumber)
                        {
                                int tempx, tempy;
                                GetPlayerLocation(Players[p][0],
                                        tempx, tempy);
                                cout<<"  "<<p<<" ("<<tempx<<","
                                    <<tempy<<")";
                        }
                }

		else if(linecount==13 && YourObjects[0])
		{
			ChatQ.QueueDelete(chat,success);
			ChatQ.QueueInsert(chat,success);
			cout << "  " <<chat;
		}


		else if(linecount==15 && YourObjects[0])
		{
                        ChatQ.QueueDelete(chat,success);
			ChatQ.QueueInsert(chat,success);
                        cout << "  " << chat;
                }

                else if(linecount==17 && YourObjects[0])
                {
                        ChatQ.QueueDelete(chat,success);
			ChatQ.QueueInsert(chat,success);
                        cout << "  " << chat;
                }

                else if(linecount==19 && YourObjects[0])
                {
                        ChatQ.QueueDelete(chat,success);
			ChatQ.QueueInsert(chat,success);
                        cout << "  " << chat;
                }

                else if(linecount==21 && YourObjects[0])
                {
                        ChatQ.QueueDelete(chat,success);
			ChatQ.QueueInsert(chat,success);
                        cout << "  " << chat;
                }

                else if(linecount==23 && YourObjects[0])
                {
                        ChatQ.QueueDelete(chat,success);
			ChatQ.QueueInsert(chat,success);
                        cout << "  " << chat;
                }

                else if(linecount==25 && YourObjects[0])
                {
                        ChatQ.QueueDelete(chat,success);
			ChatQ.QueueInsert(chat,success);
                        cout << "  " << chat;
                }

                else if(linecount==27 && YourObjects[0])
                {
                        ChatQ.QueueDelete(chat,success);
			ChatQ.QueueInsert(chat,success);
                        cout << "  " << chat;
                }


		linecount++;
		cout<<endl;
	}
}

void DecodeMatrix(unsigned int intarray [81][81], char chararray [324][324])
{
        int i,j;

	//setup initial chararray - see Initial Setup above
	for(i=0; i<324; i++)
	{
		for(j=0; j<324; j++)
		{
			int iset=i%4;
			int jset=j%4;

			if(!((iset==1||iset==2)&&(jset==1||jset==2)))
				chararray[i][j]=WALLS;
			//leave the middle empty
			else
				chararray[i][j]=' ';
		}
	}

	//setup display
        for(i=0; i<81; i++)
        {
                for(j=0; j<81; j++)
                {
                        unsigned int temp = intarray[i][j];
			int Bits[16];

			GetIntBits(temp, Bits);

			if(Bits[15]==1) //if visible
			{
                                // *** Can you go up?
                                if(Bits[0]==1) //if the U bit is set
                                {
                                        chararray[i*4][j*4+1]=' ';
					//show that the upward path is clear
                                        chararray[i*4][j*4+2]=' ';
                                }

                                // *** Can you go down?
                                if(Bits[1]) //if the D bit is set
                                {
                                        chararray[i*4+3][j*4+1]=' ';
					//show that the downward path is clear
                                        chararray[i*4+3][j*4+2]=' ';
                                }

                                // *** Can you go Left?
                                if(Bits[2]) //if the L bit is set
                                {
                                        chararray[i*4+1][j*4]=' ';
                                        chararray[i*4+2][j*4]=' ';
                                }

                                // *** Can you go Right?
                                if(Bits[3]) //if the R bit is set
                                {
                                        chararray[i*4+1][j*4+3]=' ';
                                        chararray[i*4+2][j*4+3]=' ';
                                }

				if(Bits[4]) {chararray[i*4+1][j*4+1]='Y';}

				if(Bits[5]) {chararray[i*4+1][j*4+2]='P';}

				if(Bits[6]) {chararray[i*4+2][j*4+1]='R';}
                                if(Bits[7]) {chararray[i*4+2][j*4+1]='L';}
                                if(Bits[8]) {chararray[i*4+2][j*4+1]='O';}
                                if(Bits[9]) {chararray[i*4+2][j*4+1]='S';}
                                if(Bits[10]){chararray[i*4+2][j*4+1]='H';}
                                if(Bits[11]){chararray[i*4+2][j*4+1]='G';}
                                if(Bits[12]){chararray[i*4+2][j*4+1]='A';}
                                if(Bits[13]){chararray[i*4+2][j*4+1]='+';}

				if(Bits[14]){chararray[i*4+2][j*4+2]='M';}
			}
			else //if not visible - get rid of the middle
			{
				for(int offx=0; offx<4; offx++)
					for(int offy=0; offy<4; offy++)
						chararray[i*4+offx][j*4+offy]=HIDDEN;
			}

                }
        }
}


void DisplayHelp()
{
	char cont;
	system("clear");
	cout <<"				HELP"<< endl;
	cout <<"\n\nSo thou hast decided to explore the Labrynth and take on the evil Cook-E"<<endl;
	cout <<"monster. Know that thy friends are important, for only with their assistance"<<endl;
	cout <<"canst thou corner and defeat the terror with-in the maze.  Surround him and attack,"<<endl;
	cout <<"and thou shalt surely win. Take him on alone, and thou shalt surely die."<<endl;

	cout<<"\n\nTREASURES\nWithin the Labrynth there art treasures that thou mayest find to be of"<<endl; 
	cout<<"assistance upon thy journey. Use these well, and perchance thy quest shalt be a success."<<endl;
	cout<<"R   Radio        A radio doth enable thee to communicate with any other that also"<<endl;
	cout<<"                 possesseth a radio"<<endl;
	cout<<"L   Lamp         A lamp increaseth thy range of vision"<<endl;
	cout<<"O   Oil          Add oil unto thy lamp, and shalt see even further"<<endl;
	cout<<"S   Scouts       Scouts grant thee full visibility."<<endl;
	cout<<"H   Messengers   Messengers alloweth thee to know the location of all other players"<<endl;
	cout<<"                 and to seeth what they see."<<endl;
	cout<<"G   Sheild       A sheild provideth thee with some protection against monsters."<<endl;
	cout<<"L   Lance        A lance enableth thee to attack monsters. Thy lance doth destroy regular"<<endl;
	cout<<"                 monsters and it can inflicteth some damage upon the Cook-E monster"<<endl;
	cout<<"+   Health       Increaseth thy Hit Points by 20."<<endl;

	cout<<"\n\nDANGERS\nBe forwarned.... the Labrynth is not with-out its dangers. There are two varieties"<<endl;
	cout<<"of monsters that thou shouldest be aware of."<<endl;
	cout<<"\nM   Monster        There are many regular monsters that lurketh in the Labrynth. Without a"<<endl;
	cout<<"                   lance these monsters cannot be killed. Run into them, and they shalt"<<endl;
	cout<<"                   flee, but thy health will suffer."<<endl;
	cout<<"\nC   Cook-E Monster The dreaded Cook-E Monster lurketh in the maze awaiting the approach of"<<endl; 
	cout<<"                   his victims. A quick death awaiteth any that darest to take him on alone."<<endl; 

	cout<<"\n\nCOMMANDS"<<endl;
	cout<<"a     Move left"<<endl;
	cout<<"w     Move up"<<endl;
	cout<<"d     Move right"<<endl;
	cout<<"s     Move down"<<endl;
        cout<<"t     Talk on radio"<<endl;
        cout<<"h     View helpfile"<<endl;
        cout<<"q     Quit"<<endl;

	cout<<"\n\nNOTES"<<endl;
	cout<<"Thy location is shown unto thee by means of an X-Y coordinate system. Thy X-value doth inicate"<<endl;
	cout<<"how high or low thou art in the map. The smaller thy X-value, the closer ye are to the top. Thy"<<endl;
	cout<<"Y-value indicateth thy position to the left and to the right. The smaller this number, the"<<endl;
	cout<<"closer thou art to the left. The dimensions of the entire Labrynth measureth 80 by 80."<<endl;
	cout<<"\nFor best viewing, it is recommended that thou useth the UTF-8 character set."<<endl;

	cout<<"\n\nTo returneth to the Labrynth, thou mayest press any key."<<endl;
	cin >> cont;
}
