// *********************************************************
// Implementation file QueueP.cpp for the ADT queue.
// Pointer-based implementation.
// *********************************************************
#include "Queue.h" // header file
#include <stddef.h> // for NULL
#include <iostream.h>

// The queue is implemented as a circular linked list
// with one external pointer to the back of the queue.



struct queueNode
{
  queueItemType Item[80];
  ptrType Next;
}; // end struct



queueClass::queueClass() : BackPtr(NULL)
{
} // end default constructor



queueClass::queueClass(const queueClass& Q)
{ // Implementation left as an exercise (Exercise 4).
} // end copy constructor



queueClass::~queueClass()
{
  bool Success;

  while (!QueueIsEmpty())
    QueueDelete(Success);
  // Assertion: BackPtr == NULL
} // end destructor



bool queueClass::QueueIsEmpty() const
{
  return bool(BackPtr == NULL);
} // end QueueIsEmpty



void queueClass::QueueInsert(queueItemType NewItem[80],
                             bool& Success)
{
  // create a new node
  ptrType NewPtr = new queueNode;

  Success = bool(NewPtr != NULL); // check allocation
  if (Success)
  { // allocation successful; set data portion of new node
    memcpy(&(NewPtr->Item[0]),&NewItem[0],80);

    // insert the new node
    if (QueueIsEmpty())
     // insertion into empty queue
     NewPtr->Next = NewPtr;

    else
    { // insertion into nonempty queue
      NewPtr->Next = BackPtr->Next;
      BackPtr->Next = NewPtr;
    } // end if

    BackPtr = NewPtr; // new node is at back
  } // end if
} // end QueueInsert



void queueClass::QueueDelete(bool& Success)
{
  Success = bool(!QueueIsEmpty());

  if (Success)
  { // queue is not empty; remove front
    ptrType FrontPtr = BackPtr->Next;
    if (FrontPtr == BackPtr) // special case?
      BackPtr = NULL;        // yes, one node in queue
    else
      BackPtr->Next = FrontPtr->Next;

    FrontPtr->Next = NULL; // defensive strategy
    delete FrontPtr;
  } // end if
} // end QueueDelete




void queueClass::QueueDelete(queueItemType QueueFront[80], 
                             bool& Success)
{
  Success = bool(!QueueIsEmpty());

  if (Success)
  { // queue is not empty; retrieve front
    ptrType FrontPtr = BackPtr->Next;
    memcpy(&QueueFront[0],&FrontPtr->Item[0],80);
//    QueueFront = FrontPtr->Item;
    QueueDelete(Success); // delete front
  } // end if
} // end QueueDelete



void queueClass::GetQueueFront(queueItemType QueueFront[80], 
                               bool& Success) const
{
  Success = bool(!QueueIsEmpty());
  if (Success)
  { // queue is not empty; retrieve front
    ptrType FrontPtr = BackPtr->Next;
    memcpy(&QueueFront[0],&FrontPtr->Item[0],80);
	cout << "FrontPtr->Item = " << FrontPtr->Item;
	cout << "   QFront = " << QueueFront;
//    QueueFront = FrontPtr->Item;
  } // end if
} // end GetQueueFront
// End of implementation file.

